/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.FT_EEPROM;
import com.ftdi.j2xx.FT_EEPROM_X_Series;
import com.ftdi.j2xx.FT_EE_Ctrl;

class FT_EE_X_Ctrl
extends FT_EE_Ctrl {
    private static final String DEFAULT_PID = "6015";
    private static final byte UART = 0;
    private static final byte FIFO = 1;
    private static final byte FT1248 = 2;
    private static final byte I2C = 3;
    private static final int DEVICE_TYPE_EE_LOC = 73;
    private static final int BCD_ENABLE = 1;
    private static final int FORCE_POWER_ENABLE = 2;
    private static final int DEACTIVATE_SLEEP = 4;
    private static final int RS485_ECHO = 8;
    private static final int VBUS_SUSPEND = 64;
    private static final int LOAD_DRIVER = 128;
    private static final int FT1248_CLK_POLARITY = 16;
    private static final int FT1248_BIT_ORDER = 32;
    private static final int FT1248_FLOW_CTRL = 64;
    private static final int I2C_DISABLE_SCHMITT = 128;
    private static final int INVERT_TXD = 256;
    private static final int INVERT_RXD = 512;
    private static final int INVERT_RTS = 1024;
    private static final int INVERT_CTS = 2048;
    private static final int INVERT_DTR = 4096;
    private static final int INVERT_DSR = 8192;
    private static final int INVERT_DCD = 16384;
    private static final int INVERT_RI = 32768;
    private static final int DBUS_DRIVE = 3;
    private static final int CBUS_DRIVE = 48;
    private static final int DBUS_SLEW = 4;
    private static final int DBUS_SCHMITT = 8;
    private static final int CBUS_SLEW = 64;
    private static final int CBUS_SCHMITT = 128;
    private static FT_Device ft_device;
    private static final short EE_MAX_SIZE = 1024;

    FT_EE_X_Ctrl(FT_Device usbC) {
        super(usbC);
        ft_device = usbC;
        this.mEepromSize = 128;
        this.mEepromType = 1;
    }

    @Override
    short programEeprom(FT_EEPROM ee) {
        int[] dataToWrite = new int[this.mEepromSize];
        int counter = 0;
        if (ee.getClass() != FT_EEPROM_X_Series.class) {
            return 1;
        }
        FT_EEPROM_X_Series eeprom = (FT_EEPROM_X_Series)ee;
        do {
            dataToWrite[counter] = this.readWord((short)counter);
        } while ((counter = (short)(counter + 1)) < this.mEepromSize);
        try {
            int c5;
            int c3;
            int c1;
            short driveC;
            dataToWrite[0] = 0;
            if (eeprom.BCDEnable) {
                dataToWrite[0] = dataToWrite[0] | 1;
            }
            if (eeprom.BCDForceCBusPWREN) {
                dataToWrite[0] = dataToWrite[0] | 2;
            }
            if (eeprom.BCDDisableSleep) {
                dataToWrite[0] = dataToWrite[0] | 4;
            }
            if (eeprom.RS485EchoSuppress) {
                dataToWrite[0] = dataToWrite[0] | 8;
            }
            if (eeprom.A_LoadVCP) {
                dataToWrite[0] = dataToWrite[0] | 0x80;
            }
            if (eeprom.PowerSaveEnable) {
                boolean found = false;
                if (eeprom.CBus0 == 17) {
                    found = true;
                }
                if (eeprom.CBus1 == 17) {
                    found = true;
                }
                if (eeprom.CBus2 == 17) {
                    found = true;
                }
                if (eeprom.CBus3 == 17) {
                    found = true;
                }
                if (eeprom.CBus4 == 17) {
                    found = true;
                }
                if (eeprom.CBus5 == 17) {
                    found = true;
                }
                if (eeprom.CBus6 == 17) {
                    found = true;
                }
                if (found) {
                    dataToWrite[0] = dataToWrite[0] | 0x40;
                } else {
                    return 1;
                }
            }
            dataToWrite[1] = eeprom.VendorId;
            dataToWrite[2] = eeprom.ProductId;
            dataToWrite[3] = 4096;
            dataToWrite[4] = this.setUSBConfig(ee);
            dataToWrite[5] = this.setDeviceControl(ee);
            if (eeprom.FT1248ClockPolarity) {
                dataToWrite[5] = dataToWrite[5] | 0x10;
            }
            if (eeprom.FT1248LSB) {
                dataToWrite[5] = dataToWrite[5] | 0x20;
            }
            if (eeprom.FT1248FlowControl) {
                dataToWrite[5] = dataToWrite[5] | 0x40;
            }
            if (eeprom.I2CDisableSchmitt) {
                dataToWrite[5] = dataToWrite[5] | 0x80;
            }
            if (eeprom.InvertTXD) {
                dataToWrite[5] = dataToWrite[5] | 0x100;
            }
            if (eeprom.InvertRXD) {
                dataToWrite[5] = dataToWrite[5] | 0x200;
            }
            if (eeprom.InvertRTS) {
                dataToWrite[5] = dataToWrite[5] | 0x400;
            }
            if (eeprom.InvertCTS) {
                dataToWrite[5] = dataToWrite[5] | 0x800;
            }
            if (eeprom.InvertDTR) {
                dataToWrite[5] = dataToWrite[5] | 0x1000;
            }
            if (eeprom.InvertDSR) {
                dataToWrite[5] = dataToWrite[5] | 0x2000;
            }
            if (eeprom.InvertDCD) {
                dataToWrite[5] = dataToWrite[5] | 0x4000;
            }
            if (eeprom.InvertRI) {
                dataToWrite[5] = dataToWrite[5] | 0x8000;
            }
            dataToWrite[6] = 0;
            short driveA = eeprom.AD_DriveCurrent;
            if (driveA == -1) {
                driveA = 0;
            }
            dataToWrite[6] = dataToWrite[6] | driveA;
            if (eeprom.AD_SlowSlew) {
                dataToWrite[6] = dataToWrite[6] | 4;
            }
            if (eeprom.AD_SchmittInput) {
                dataToWrite[6] = dataToWrite[6] | 8;
            }
            if ((driveC = (short)eeprom.AC_DriveCurrent) == -1) {
                driveC = 0;
            }
            driveC = (short)(driveC << 4);
            dataToWrite[6] = dataToWrite[6] | driveC;
            if (eeprom.AC_SlowSlew) {
                dataToWrite[6] = dataToWrite[6] | 0x40;
            }
            if (eeprom.AC_SchmittInput) {
                dataToWrite[6] = dataToWrite[6] | 0x80;
            }
            int offset = 80;
            offset = this.setStringDescriptor(eeprom.Manufacturer, dataToWrite, offset, 7, false);
            offset = this.setStringDescriptor(eeprom.Product, dataToWrite, offset, 8, false);
            if (eeprom.SerNumEnable) {
                offset = this.setStringDescriptor(eeprom.SerialNumber, dataToWrite, offset, 9, false);
            }
            dataToWrite[10] = eeprom.I2CSlaveAddress;
            dataToWrite[11] = eeprom.I2CDeviceID & 0xFFFF;
            dataToWrite[12] = eeprom.I2CDeviceID >> 16;
            byte c0 = eeprom.CBus0;
            if (c0 == -1) {
                c0 = 0;
            }
            if ((c1 = eeprom.CBus1) == -1) {
                c1 = 0;
            }
            dataToWrite[13] = (short)(c0 | (c1 <<= 8));
            byte c2 = eeprom.CBus2;
            if (c2 == -1) {
                c2 = 0;
            }
            if ((c3 = eeprom.CBus3) == -1) {
                c3 = 0;
            }
            dataToWrite[14] = (short)(c2 | (c3 <<= 8));
            byte c4 = eeprom.CBus4;
            if (c4 == -1) {
                c4 = 0;
            }
            if ((c5 = eeprom.CBus5) == -1) {
                c5 = 0;
            }
            dataToWrite[15] = (short)(c4 | (c5 <<= 8));
            byte c6 = eeprom.CBus6;
            if (c6 == -1) {
                c6 = 0;
            }
            dataToWrite[16] = c6;
            if (dataToWrite[1] != 0 && dataToWrite[2] != 0) {
                boolean returnCode = false;
                returnCode = this.programXeeprom(dataToWrite, this.mEepromSize - 1);
                if (returnCode) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    boolean programXeeprom(int[] dataToWrite, int ee_size) {
        int checksumLocation = ee_size;
        int Checksum = 43690;
        int TempChecksum = 0;
        int addressCounter = 0;
        int a = 0;
        int b = 0;
        int data = 0;
        do {
            data = dataToWrite[addressCounter];
            this.writeWord((short)addressCounter, (short)(data &= 0xFFFF));
            TempChecksum = data ^ Checksum;
            a = (TempChecksum &= 0xFFFF) << 1;
            b = (TempChecksum & 0x8000) > 0 ? 1 : 0;
            Checksum = (a &= 0xFFFF) | b;
            Checksum &= 0xFFFF;
            if (++addressCounter != 18) continue;
            addressCounter = 64;
        } while (addressCounter != checksumLocation);
        this.writeWord((short)checksumLocation, (short)Checksum);
        return true;
    }

    @Override
    FT_EEPROM readEeprom() {
        FT_EEPROM_X_Series eeprom = new FT_EEPROM_X_Series();
        int[] dataRead = new int[this.mEepromSize];
        try {
            for (short i = 0; i < this.mEepromSize; i = (short)(i + 1)) {
                dataRead[i] = this.readWord(i);
            }
            eeprom.BCDEnable = (dataRead[0] & 1) > 0;
            eeprom.BCDForceCBusPWREN = (dataRead[0] & 2) > 0;
            eeprom.BCDDisableSleep = (dataRead[0] & 4) > 0;
            eeprom.RS485EchoSuppress = (dataRead[0] & 8) > 0;
            eeprom.PowerSaveEnable = (dataRead[0] & 0x40) > 0;
            if ((dataRead[0] & 0x80) > 0) {
                eeprom.A_LoadVCP = true;
                eeprom.A_LoadD2XX = false;
            } else {
                eeprom.A_LoadVCP = false;
                eeprom.A_LoadD2XX = true;
            }
            eeprom.VendorId = (short)dataRead[1];
            eeprom.ProductId = (short)dataRead[2];
            this.getUSBConfig(eeprom, dataRead[4]);
            this.getDeviceControl(eeprom, dataRead[5]);
            eeprom.FT1248ClockPolarity = (dataRead[5] & 0x10) > 0;
            eeprom.FT1248LSB = (dataRead[5] & 0x20) > 0;
            eeprom.FT1248FlowControl = (dataRead[5] & 0x40) > 0;
            eeprom.I2CDisableSchmitt = (dataRead[5] & 0x80) > 0;
            eeprom.InvertTXD = (dataRead[5] & 0x100) == 256;
            eeprom.InvertRXD = (dataRead[5] & 0x200) == 512;
            eeprom.InvertRTS = (dataRead[5] & 0x400) == 1024;
            eeprom.InvertCTS = (dataRead[5] & 0x800) == 2048;
            eeprom.InvertDTR = (dataRead[5] & 0x1000) == 4096;
            eeprom.InvertDSR = (dataRead[5] & 0x2000) == 8192;
            eeprom.InvertDCD = (dataRead[5] & 0x4000) == 16384;
            eeprom.InvertRI = (dataRead[5] & 0x8000) == 32768;
            short data01x06 = (short)(dataRead[6] & 3);
            switch (data01x06) {
                case 0: {
                    eeprom.AD_DriveCurrent = 0;
                    break;
                }
                case 1: {
                    eeprom.AD_DriveCurrent = 1;
                    break;
                }
                case 2: {
                    eeprom.AD_DriveCurrent = (byte)2;
                    break;
                }
                case 3: {
                    eeprom.AD_DriveCurrent = (byte)3;
                    break;
                }
            }
            short data2x06 = (short)(dataRead[6] & 4);
            eeprom.AD_SlowSlew = data2x06 == 4;
            short data3x06 = (short)(dataRead[6] & 8);
            eeprom.AD_SchmittInput = data3x06 == 8;
            short data45x06 = (short)((dataRead[6] & 0x30) >> 4);
            switch (data45x06) {
                case 0: {
                    eeprom.AC_DriveCurrent = 0;
                    break;
                }
                case 1: {
                    eeprom.AC_DriveCurrent = 1;
                    break;
                }
                case 2: {
                    eeprom.AC_DriveCurrent = (byte)2;
                    break;
                }
                case 3: {
                    eeprom.AC_DriveCurrent = (byte)3;
                    break;
                }
            }
            short data6x06 = (short)(dataRead[6] & 0x40);
            eeprom.AC_SlowSlew = data6x06 == 64;
            short data7x06 = (short)(dataRead[6] & 0x80);
            eeprom.AC_SchmittInput = data7x06 == 128;
            eeprom.I2CSlaveAddress = dataRead[10];
            eeprom.I2CDeviceID = dataRead[11];
            eeprom.I2CDeviceID |= (dataRead[12] & 0xFF) << 16;
            eeprom.CBus0 = (byte)(dataRead[13] & 0xFF);
            eeprom.CBus1 = (byte)(dataRead[13] >> 8 & 0xFF);
            eeprom.CBus2 = (byte)(dataRead[14] & 0xFF);
            eeprom.CBus3 = (byte)(dataRead[14] >> 8 & 0xFF);
            eeprom.CBus4 = (byte)(dataRead[15] & 0xFF);
            eeprom.CBus5 = (byte)(dataRead[15] >> 8 & 0xFF);
            eeprom.CBus6 = (byte)(dataRead[16] & 0xFF);
            this.mEepromType = (short)(dataRead[73] >> 8);
            int addr = dataRead[7] & 0xFF;
            eeprom.Manufacturer = this.getStringDescriptor(addr /= 2, dataRead);
            addr = dataRead[8] & 0xFF;
            eeprom.Product = this.getStringDescriptor(addr /= 2, dataRead);
            addr = dataRead[9] & 0xFF;
            eeprom.SerialNumber = this.getStringDescriptor(addr /= 2, dataRead);
            return eeprom;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    int getUserSize() {
        int data = this.readWord((short)9);
        int ptr = data & 0xFF;
        ptr /= 2;
        int length = (data & 0xFF00) >> 8;
        ptr += length / 2;
        return (this.mEepromSize - 1 - 1 - ++ptr) * 2;
    }

    @Override
    int writeUserData(byte[] data) {
        int i;
        int dataWrite = 0;
        short offset = 0;
        if (data.length > this.getUserSize()) {
            return 0;
        }
        int[] eeprom = new int[this.mEepromSize];
        for (i = 0; i < this.mEepromSize; i = (short)(i + 1)) {
            eeprom[i] = this.readWord((short)i);
        }
        offset = (short)(this.mEepromSize - this.getUserSize() / 2 - 1 - 1);
        for (i = 0; i < data.length; i += 2) {
            dataWrite = i + 1 < data.length ? data[i + 1] & 0xFF : 0;
            dataWrite <<= 8;
            short s = offset;
            offset = (short)(offset + 1);
            eeprom[s] = dataWrite |= data[i] & 0xFF;
        }
        if (eeprom[1] != 0 && eeprom[2] != 0) {
            boolean returnCode = false;
            returnCode = this.programXeeprom(eeprom, this.mEepromSize - 1);
            if (!returnCode) {
                return 0;
            }
        } else {
            return 0;
        }
        return data.length;
    }

    @Override
    byte[] readUserData(int length) {
        byte Hi = 0;
        byte Lo = 0;
        int dataRead = 0;
        byte[] data = new byte[length];
        if (length == 0 || length > this.getUserSize()) {
            return null;
        }
        short offset = (short)(this.mEepromSize - this.getUserSize() / 2 - 1 - 1);
        for (int i = 0; i < length; i += 2) {
            short s = offset;
            offset = (short)(offset + 1);
            dataRead = this.readWord(s);
            if (i + 1 < data.length) {
                data[i + 1] = Hi = (byte)(dataRead & 0xFF);
            } else {
                Lo = 0;
            }
            data[i] = Lo = (byte)((dataRead & 0xFF00) >> 8);
        }
        return data;
    }
}

