/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import android.util.Log;
import com.ftdi.j2xx.InBuffer;
import com.ftdi.j2xx.ProcessInCtrl;

class ProcessRequestWorker
implements Runnable {
    private ProcessInCtrl mProInCtrl;
    int mNrBuf;

    ProcessRequestWorker(ProcessInCtrl inCtrl) {
        this.mProInCtrl = inCtrl;
        this.mNrBuf = this.mProInCtrl.getParams().getBufferNumber();
    }

    @Override
    public void run() {
        InBuffer inBuf = null;
        int bufferIndex = 0;
        try {
            do {
                if ((inBuf = this.mProInCtrl.acquireReadableBuffer(bufferIndex)).getLength() > 0) {
                    this.mProInCtrl.processBulkInData(inBuf);
                    inBuf.purge();
                }
                this.mProInCtrl.releaseWritableBuffer(bufferIndex);
                ++bufferIndex;
                bufferIndex %= this.mNrBuf;
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
        catch (InterruptedException ex) {
            Log.d((String)"ProcessRequestThread::", (String)"Device has been closed.");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            Log.e((String)"ProcessRequestThread::", (String)"Fatal error!");
            ex.printStackTrace();
        }
    }
}

